//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.4 Page Number 387
// Title - Pressure drop at  minimum fluidisation
//========================================================================
model Ex26_4
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi"The value of pi";
    parameter Real D(unit="m")=0.2              "Bed Diameter";
    parameter Real dp(unit="m")=7.4E-5          "Diameter of the particle";
    parameter Real rho_s(unit="kg/m^3")=2200    "Ultimate solid density";
    parameter Real rho_f(unit="kg/m^3")=1.2     "Density of the fluid";
    parameter Real meuf(unit="kg/m.s")=1.89E-5   "Viscosity of air";
    parameter Real g(unit="m/s^2")=9.807        "Acceleration due to gravity";
    parameter Real e_mf=0.45                    "Bed porosity";
    parameter Real Lmf(unit="m")=0.3            "Length at minimum fluidisation";
//============================================= 
///////Variable section///////////////////////////
    Real vmf_tur(unit="m/s")                    "Minimum fluidization velocity in turbulent condn";
    Real vmf_lam(unit="m/s")                    "Minimum fluidization velocity in laminar condn";
    Real Re_tur                                 "Reynolds number to check if the flow is turbulent";
    Real Re_lam                                 "Reynolods number to check if the flow is laminar";
    Real m(unit="kg/s")                         "Mass flow rate";
    Real DelPfr(unit="Pa")                        "Pressure drop at minimum fluidisation";
//============================================== 
//Equation Section
equation
    vmf_tur=(((e_mf^3)*g*(rho_s-rho_f)*dp)/(1.75*rho_f))^0.5;//As per quation 26.31
    Re_tur=(vmf_tur*dp)/(meuf*(1-e_mf));//As Re_tur<1000 turbulent conditions does not apply check for laminar condition.
    vmf_lam=((1-e_mf)*g*rho_s*(dp^2))/(150*(e_mf^3)*meuf);
    Re_lam=(vmf_lam*dp)/(meuf*(1-e_mf));//As Re_lam<10  It is laminar flow.
    m=(pi*(D^2)*vmf_lam*rho_f)/4;
    DelPfr=(1-e_mf)*rho_s*g*Lmf;
end Ex26_4;
//============================================================================
