// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 27 Filtration
// Illustrative Example 27.5 Page Number 415
// Title - Filteration coefficient
//========================================================================
model Ex27_5
//////Parameter section///////////////////////
//============================================
  parameter Real meu(unit="lb/ft.s")=5.95E-4                 "Viscosity of the fluid";
  parameter Real gc(unit="lb.ft/lbf.s^2")=32.174             "Conversion constant";
  parameter Real S(unit="ft^2")=0.35                         "Filterartion area";
  parameter Real DelP(unit="psig")=20                        "Pressure drop";
  parameter Real qo(unit="s/ft^3")=217                       "Coefficient 1/qo";
  parameter Real Kc(unit="s/ft^6")=3894                      "Coefficient";
  parameter Real c(unit="lb/ft^3")=4.142                     "Slurry Concentration per volume of filtrate";
//============================================= 
///////Variable section///////////////////////////
  Real Rm(unit="ft")"Resistance medium";
  Real alpha(unit="ft/lb")"Specific cake resistance";
//============================================== 
//Equation Section 
equation
  Rm=(S*gc*DelP*144*qo)/meu;//Converting psig to psf
  alpha=(Kc*(S^2)*gc*DelP*144)/(c*meu);
end Ex27_5;
//============================================================================
