// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 27 Filtration
// Illustrative Example 27.6 Page Number 416
// Title - Quantity of slurry treated
//========================================================================
model Ex27_6
//////Parameter section///////////////////////
//============================================
    parameter Real DelP_30(unit="in H2O")=5            "Final Pressure drop";
    parameter Real q(unit="ft^3/min")=100              "Volumetric flow rate";
    parameter Real t(unit="min")=30                    "Operating time";
    parameter Real DelP(unit="in H2O")=0.5             "Intial Pressure drop";
//============================================= 
///////Variable section///////////////////////////    
    Real C(unit="in H2O .min/ft^3")                    "Design Coefficients";
    Real Vs(unit="ft^3")                               "Volume filtered";
    Real D(unit="in H2O .min/ft^3")                    "Represents the resistance of the filter and solid deposited";
    Real B(unit="in H2O .min/ft^3")                    "Design Coefficients";
    Real Total(unit="ft^3")                            "Total quantity of slurry filtered";
//============================================== 
//Equation Section     
equation
    (DelP)=C*q;//At t=0
    DelP_30=(B*(q^2)*t)+(C*q);//At t=30 min
    DelP_30=D*q;//As Vs=0
    t=((B/(2*DelP_30))*(Vs^2))+((D/DelP_30)*Vs);
    Total=(q*t)+Vs;
end Ex27_6;
//Remark:The answer provided in the textbook for Vs is wrong.Calculation error.
//============================================================================
