// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.9 Page Number 437
// Title - Time to fill the cavern
//========================================================================
model Ex28_9
//////Parameter section///////////////////////
//============================================
    parameter Real Vc(unit="mi^3")=0.78         "Volume of the cavern";
    parameter Real Vs=0.75                      "Percentage Volume available for solid waste";
    parameter Real m(unit="lb/day")=20000       "Maximum feed rate.";
    parameter Real rho(unit="lb/ft^3")=30        "Density of waste";
//============================================= 
///////Variable section///////////////////////////    
    Real V(unit="ft^3")                        "Volume available in the cavern";
    Real q(unit="ft^3/yr")                     "Volumetric flow rate of solid deposited";
    Real t(unit="yr")                          "Time to fill cavern";
//============================================== 
//Equation Section    
equation
    V=Vc*Vs*(5280^3);// Conversion of mi to ft.
    q=(m/rho)*(6*52);//As the feet rate schedule is 6 days per week and converting to ft^3/yr
    t=V/q;
end Ex28_9;
//=========================================================================
