// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 29 Accident and emergency management
// Illustrative Example 29.2 Page Number 455
// Title - Probability distribution
//========================================================================
model Ex29_2
//////Parameter section///////////////////////
//============================================
      parameter Real p=0.05        "Probability of success";
      parameter Real q=0.95        "Probability of failure";
      Real n=5                     "Number of performances";
      Real x=3                     "Number of success";
//============================================= 
///////Variable section///////////////////////////      
      Real y[6]                    "Calculation of 5!";
      Real X[4]                    "Calculation of 3!";   
      Real P                       "Probability when x=3";
//============================================== 
//Equation Section      
equation
      y[1]=1;
      X[1]=1;
      for i in 2:6 loop
      y[i]=y[i-1]*(i-1);
      end for;
      for i in 2:4 loop
      X[i]=X[i-1]*(i-1);
      end for;
// y[6] is the value of 5! and X[4] is the value of 3!
      P=(y[6]*(p^x)*(q^(n-x)))/(X[4]*(y[6]-X[4]));
end Ex29_2;
//Remark: The answer provided in the textbook for P(x=3)is wrong.Calculation error.
//============================================================================
