// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 29 Accident and emergency management
// Illustrative Example 29.6 Page Number 458
// Title -  Baghouse to clean a particulate steam
//========================================================================
model Ex29_6
//////Parameter section///////////////////////
//============================================
    parameter Real inlet(unit="grains/ft^3")=5       "Inlet loading grains";
    parameter Real outlet(unit="grains/ft^3")=0.3    "Outlet loading grains";
    parameter Real Max(unit="grains/ft^3")=0.4       "Maximum outlet loading";
    parameter Real DelP(unit="in H2O")=6             "Pressure drop";
    parameter Real T(unit="degF")=250                "Temperature";
    parameter Real q(unit="acfm")=50000              "Volumetric flow rate";
    parameter Real D(unit="in")=8                    "Diameter of bags";
//============================================= 
///////Variable section///////////////////////////
    Real L                                "Number of broken bags";
    Real E                                "Efficiency of regulatory conditions";
    Real Eb                               "Efficiency before bag failure";
    Real Pt                               "Penetration before bag failure";
    Real Ptreg                            "Penetration regulatory conditions";
    Real Ptc                              "Penetration associated with failed bags";
//============================================== 
//Equation Section
equation
//Before Bag failure
    Eb=(inlet-outlet)/inlet;
    Pt=1-Eb;
//Based on regulatory conditions
    E=(inlet-Max)/inlet;
    Ptreg=1-E;
    Ptc=Ptreg-Pt;
    L=(q*Ptc)/(0.582*(DelP^0.5)*(D^2)*((T+460)^0.5));
end Ex29_6;
//Remark: The answer provided in the textbook for Eb is wrong as the value of outlet loading is taken as 0.03 grains/ft^3 instead of 0.3 grains/ft^3 as given in the question 
//============================================================================
