// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 3 Key Terms and Definitions
// Illustrative Example 3.3 Page Number 26
// Title - Diameter of the glass tube
//========================================================================
model Ex3_3
//////Parameter section///////////////////////
//============================================
    parameter Real sigma(unit="N/m") = 0.071                "Surface Tension";
    parameter Real theta(unit="deg")=0                      "Contact Angle";
    parameter Real rho(unit="kg/m^3")=996                   "Density of the fluid";
    parameter Real h(unit="m")=0.001                        "Height of the liquid in the capillary tube";
    parameter Real g(unit="m/s^2")=9.807                    "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real D(unit="mm")                                       "Diameter of the glass tube";
    Real R(unit="mm")                                       "Radius of the glass tube";
//============================================== 
//Equation Section
equation
    h=((2*sigma*cos(theta))/(rho*g*R))*1000;//Converting m to mm
    R=D/2;//If the diameter of the glass tube is greater than D then h(Capillary rise) will be less than 1 mm.
end Ex3_3;
//============================================================================
