// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 3 Key Terms And Definitions 
// Illustrative Example 3.4 Page Number 28
// Title - Magnitude of the normal and parallel forces
//========================================================================
model Ex3_4
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi     "The value of pi";
    parameter Real S(unit="ft^2")=2                  "Surface area";
    parameter Real theta(unit="deg")=30              "Given Angle";
    parameter Real F(unit="lbf")=10                  "Given Force";
//============================================= 
///////Variable section///////////////////////////
    Real P(unit="psf")                               "Pressure";
    Real shearstress(unit="psf")                     "Shear stress";
    Real Fpara(unit="lbf")                           "Magnitude of parallel force  component";
    Real Fnorm(unit="lbf")                           "Magnitude of normal force  component";
//============================================== 
//Equation Section    
equation
    Fnorm=F*sin(theta*pi/180);
    Fpara=F*cos(theta*pi/180);
    P=Fnorm/S;
    shearstress=Fpara/S;
end Ex3_4;
//============================================================================
