// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 32 Economics and Finance
// Illustrative Example 32.8 Page Number 514
// Title - Appraisal value of the Press filter.
//========================================================================
model Ex32_8
//////Parameter section///////////////////////
//============================================
    parameter Real i=0.03375                    "Interst on the fund";
    parameter Real n(unit="years")=9            "Life time";
    parameter Real P(unit="$")=60000            "Cost of the fliter press";
    parameter Real L(unit="$")=500              "Salvage value";
    parameter Real x(unit="years")=5            "After 5 years from the present";
//============================================= 
///////Variable section///////////////////////////    
    Real B5(unit="$")                           "Appraissl value of 5 years";
    Real UAP(unit="$")                          "Uniform annual payment";
    Real SFDF                                   "Sinking Fund Depreciation factor";
//============================================== 
//Equation Section    
equation
    SFDF=i/((i+1)^n-1);
    UAP=(P-L)*SFDF;
    B5=P-(((P-L)/n)*x);
end Ex32_8;
//=========================================================================
