// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 32 Economics and Finance
// Illustrative Example 32.9 Page Number 515
// Title - Annualized cost of the new control device.
//========================================================================
model Ex32_9
//////Parameter section///////////////////////
//============================================
    parameter Real CC(unit="$")=150000             "Capital Cost";
    parameter Real i=0.07                          "Interest rate";
    parameter Real n(unit="yr")=5                  "Term";
    parameter Real OC(unit="$")=15000              "Operating cost";
//============================================= 
///////Variable section///////////////////////////
    Real CRF                                       "Capital recovery factor";
    Real IC(unit="$")                              "Installation cost";
    Real AC(unit="$")                              "Annulized cost";
//============================================== 
//Equation Section        
equation
    CRF=(i*((1+i)^n))/((1+i)^n-1);
    IC=CRF*CC;
    AC=IC+OC;//As AC <75000 $ The proposed plan can be subsituted.
end Ex32_9;
//=========================================================================
