// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.10 Page Number 532
// Title -  Pressure drop for the flow of blood
//========================================================================
model Ex33_10
//////Parameter section///////////////////////
//============================================ 
  parameter Real DelP_min(unit="mmHg")=40            "Minimum pressure drop";
  parameter Real meu(unit="cP")=1.1                  "Viscosity of the blood";
  parameter Real L(unit="mile")=0.3                  "Length from the aorta to the atrium";
  parameter Real g_c(unit="lb.ft/lbf.s^2")=32.2      "Unit conversion factor";
  parameter Real rho(unit="lb/ft^3")=62.4            "Density of the fluid";
  parameter Real D(unit="cm")=2.5                    "Diameter of vessel";
  parameter Real v(unit="cm/s")=19                   "Velocity of the blood";
//============================================= 
///////Variable section///////////////////////////
  Real DelP(unit="ft.lbf/lb")                         "Calculated Pressure drop";
//============================================== 
//Equation Section
equation
  DelP=(32*meu*6.72E-4*(v/30.48)*5280*L)/(rho*((D/30.48)^2)*g_c);//Converting cP to lb/ft.s and mile to ft , cm to ft
end Ex33_10;
//Remark: In the textbook the Diameter in the DelP expression is taken as 2.53 cm instead of 2.5 cm .
//========================================================================
