// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.9 Page Number 531
// Title - Volume of the blood circulated
//========================================================================
model Ex33_9
//////Parameter section///////////////////////
//============================================  
    parameter Real T=3.11E9            "Number of times the heart beats";
    parameter Real age(unit="years")=74 "Age of the person";
//============================================= 
///////Variable section///////////////////////////
    Real V(unit="L")                  "Volume of blood circulated";
//============================================== 
//Equation Section 
equation
   V=(T*age)/(10^3);//Converting mL to L
end Ex33_9;
//Remark: The answer given in the book for V is wrong as the value of age is taken as 70 years instead of 74 years
//========================================================================
