// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 5 Newtonian fluids 
// Illustrative Example 5.4 Page Number 45
// Title - Dynamic and kinematic viscosity
//========================================================================
model Ex5_4
//////Parameter section///////////////////////
//============================================
    parameter Real pi=Modelica.Constants.pi           "The value of pi";
    parameter Real omega(unit="rpm")=250              "Angular velocity";
    parameter Real D(unit="ft")=0.25                  "Diameter of the inner cylinder";
    parameter Real d(unit="in")=0.001                 "Clearance between the  cylinders";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174    "Conversion constant";
    parameter Real tou(unit="psf")=311.7              "Shear stress";
    parameter Real SG=0.97                            "Specific gravity of the fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real neu(unit="ft^2/s")                           "Kinematic viscosity";
    Real meu(unit="lb/ft.s")                          "Viscosity of the fluid";
    Real dv_dy(unit="s^-1")                           "Velcoity gradient";
    Real v(unit="ft/s")                               "Linear velocity of the oil";
    Real omega1(unit="rad/s")                         "Angular velocity in rad/s";
//============================================== 
//Equation Section
equation
    omega1=omega*2*pi/60;//Conversion of rpm to rad/s
    v=omega1*D/2;
    dv_dy=v/(d/12);//Convertion of d from in to ft
    meu=gc*tou/dv_dy;
    neu=meu/(SG*62.4);//Conversion of SG to Density of the fluid.
end Ex5_4;
//============================================================================
