// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 8 Conservation Law For Energy
// Illustrative Example 8.2 Page Number 77 
// Title - Work done on the system
//========================================================================
model Ex8_2
//////Parameter section///////////////////////
//============================================
    parameter Real q1(unit="m^3/s")=8       "Volumetric flow rate at section 1";
    parameter Real q2(unit="m^3/s")=6       "Volumetric flow rate at section 2";
    parameter Real q3(unit="m^3/s")=14      "Volumetric flow rate at section 3";
    parameter Real h1(unit="J/kg")=250      "Enthalpy at section 1";
    parameter Real h2(unit="J/kg")=150      "Enthalpy at section 2";
    parameter Real h3(unit="J/kg")=200      "Enthalpy at section 3";
    parameter Real rho(unit="kg/m^3")=800   "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////
    Real DelH(unit="J/s")                   "Difference in enthalpy";
    Real Ws(unit="hp")                      "Work done";
//============================================== 
//Equation Section
equation
  DelH=rho*((q1*h1)+(q2*h2)-(q3*h3));
  Ws=DelH/746;//Conversion of W to hp
//As  Ws is positive the work done is on the system by the surrounding
end Ex8_2;
//============================================================================


