// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 9  Conservation Law For Momentum
// Illustrative Example 9.1 Page Number 87
// Title - Required force to hold the plate
//========================================================================
model Ex9_1
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi            "The value of pi";
    parameter Real rho(unit="lb/ft^3")=62.4                 "Density of the fluid";
    parameter Real v(unit="ft/s")=100                       "Horizontal Velocity of the fluid";
    parameter Real q(unit="ft^3/s")=0.5                     "Volumetric flow rate";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.2            "Conversion constant";
    parameter Real angle(unit="deg")=10                     "Given angle of the jet";
    parameter Real Mout(unit="lbf")=0                       "Horizontal momentum rate for outlet";
//============================================= 
///////Variable section///////////////////////////    
    Real Min(unit="lbf")                "Horizontal momentum rate for inlet";
    Real F(unit="lbf")                  "Net horizontal force ";
    Real F_recalc(unit="lbf")           "Recalculated net horizontal force for the jet with an angle 10 degree";
//============================================== 
//Equation Section
equation
  Min=(rho*q*v)/gc;
  F=Mout-Min;
  F_recalc=Mout-(Min*cos(angle*pi/180));//The negative sign indicates that a force must be provided in the opposite direction.
end Ex9_1;
//============================================================================


