// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 9  Conservation Law For Momentum
// Illustrative Example 9.2 Page Number 87
// Title - Required force to hold the elbow in place
//========================================================================
model Ex9_2
//////Parameter section///////////////////////
//============================================
    parameter Real m(unit="kg/s")=0.15   "Mass flow rate of steam";
    parameter Real vin_x(unit="m/s")=420 "Velocity at the inlet in the x direction";
    parameter Real vout_x(unit="m/s")=0  "Velocity at the outlet in the x direction";
    parameter Real vin_y(unit="m/s")=0   "Velocity at the inlet in the y direction";
    parameter Real vout_y(unit="m/s")=420"Velocity at the outlet in the y direction";
//============================================= 
///////Variable section///////////////////////////
     Real Fx(unit="N")                 "Force in x direction";
     Real Fy(unit="N")                 "Force in y direction";
     Real Fres(unit="N")               "Resultant force";
//============================================== 
//Equation Section
equation
    Fx=(m*vout_x)-(m*vin_x);
    Fy=(m*vout_y)-(m*vin_y);
    Fres=((Fx^2)+(Fy^2))^0.5;//This Force is required to hold the elbow in place
end Ex9_2;
//============================================================================


