// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.2 Page Number 99
// Title - Calculate the depth at a particular pressure
//========================================================================
model Ex10_2
//////Parameter section///////////////////////
//============================================
    parameter Real z1(unit="m")=0              "Ocean surface";
    parameter Real rho(unit="kg/m^3")=1000     "Density of the fluid";
    parameter Real P2(unit="atm")=10           "Pressure at z2" ;
    parameter Real P1(unit="atm")=1            "Pressure at the ocean surface";
    parameter Real g(unit="m/s^2")=9.807       "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real z2(unit="m")                          "Depth at Pressure P2";
//============================================== 
//Equation Section
equation
   ((P1*101325)/(rho*g))+z1=((P2*101325)/(rho*g))+z2;//As per equation 10.6
end Ex10_2;
//============================================================================


