// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.6 Page Number 105
// Title - Manometer
//========================================================================
model Ex10_6
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="lb/ft^3")=62.4      "Density of water";
    parameter Real sg=1.4                        "Specific gravity of carbon tetrachloride";
    parameter Real h(unit="ft")=3                "Height in the manometer";
    parameter Real Pr(unit="psia")=14.7          "Pressure at the right leg of the manometer";
//============================================= 
///////Variable section///////////////////////////    
    Real DelPw(unit="psi")         "Pressure due to the height of water";
    Real DelP(unit="psi")          "Pressure due to the carbon tetra chloride";
    Real Pa(unit="psia")           "Absolute pressure";
    Real Pg(unit="psig")           "Gauge pressure";
    Real P_psfa(unit="psfa")       "Pressure in psfa";
    Real P_psfg(unit="psfg")       "Gauge pressure  in psfg";
//============================================== 
//Equation Section    
equation
    DelP=rho*sg*h/144;//Conversion of psf to psi
    DelPw=rho*h/144;//Conversion of psf to psi
    Pa=Pr+DelPw-DelP;
    Pg=Pa-14.7;
    P_psfa=Pa*144;//Conversion of psia to psfa
    P_psfg=(Pa-14.7)*144;//Conversion of psig to psfg
end Ex10_6;
//============================================================================

