// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 11 Ideal gas law 
// Illustrative Example 11.4 Page Number 115
// Title - Standard volumetric flow rate
//========================================================================
model Ex11_4
//////Parameter section///////////////////////
//============================================     
    parameter Real m(unit="lb/min")=50                      "Mass flow rate";
    parameter Real MW(unit="lb/lbmol")=29                   "Molecular weight";
    parameter Real T(unit="degF")=60                        "Standard temperature";
    parameter Real P(unit="atm")=1                          "Standard pressure";
    parameter Real R(unit="atm.ft^3/lbmol.degR")=0.73       "Gas constant";
//============================================= 
///////Variable section///////////////////////////   
    Real qs(unit="scfm")                                    "Standard volumetric flow  rate";
    Real V_n(unit="scf/lbmol")                              "Volume of 1 lbmol of ideal gas";
//============================================== 
//Equation Section    
equation
    V_n=(R*(T+460))/P;//Temperature converted from degF to degR.
    qs=(m/MW)*(V_n);
end Ex11_4;
//============================================================================
