package Ex11__6
  // J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
  // Edition : 1
  // Chapter : 11 Ideal gas law
  // Illustrative Example 11.6 Page Number 118
  // Title - Specific volume of SO2
  //========================================================================
  //////Parameter section///////////////////////
  //============================================
model Ex11_6a
    parameter Real B(unit="m^3/kgmol") = -0.159     "First virial coefficients ";
    parameter Real C(unit="(m^3/kgmol)^2") = 0.009  "Second virial coefficients"; 
    parameter Real R(unit="L.atm/gmol.K")  = 0.082  "Gas constant ";
    parameter Real T(unit="K")= 400                 "Temperature"; 
    parameter Real P(unit="atm") = 40               "Pressure";
  //=============================================
  ///////Variable section///////////////////////////
    Real V[4](each unit = "L/gmol")           "Specific Volume";
    Real V_SO2(unit = "L/gmol")               "Specific Volume of SO2";
  //==============================================
  //Equation Section
  equation
    V[1] =1/(P / (R * T));//Initial value from the ideal gas condition
    for i in 1:3 loop
      V[i + 1] = Ex11_6(V[i]);
    end for;
    V_SO2 = V[4];
  //============================================================================
  end Ex11_6a;
 function Ex11_6
    input Real V;//Input the value of specific volume in L/gmol.
    output Real Vnew;//Output the value of Specific Volume in L/gmol.
  protected
    parameter Real B = -0.159;//First virial coefficients in m^3/kgmol.
    parameter Real C = 0.009;//Second virial coefficients in (m^3/kgmol)^2
    parameter Real R = 0.082;//Gas constant in L.atm/gmol.K
    parameter Real T = 400;//Temperature in K
    parameter Real P = 40;//Pressure in atm
  algorithm
    Vnew := (1 + (B / V) + (C / (V ^ 2))) / (P / (R * T));
  end Ex11_6;
end Ex11__6;
