// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 12 Flow mechanisms 
// Illustrative Example 12.2 Page Number 125
// Title - Reynolds number
//========================================================================
model Ex12_2
//////Parameter section///////////////////////
//============================================
  parameter Real L(unit="cm")=2.54                     "Diameter of the pipe";
  parameter Real rho(unit="g/cm^3")=1.50               "Density of the fluid";
  parameter Real v(unit="cm/s")=20                     "Velocity of the fluid";
  parameter Real meu(unit="g/cm.s")=0.78E-2            "Viscosity of the fluid";
//============================================= 
///////Variable section///////////////////////////
  Real Re                                               "Reynolds number";
//============================================== 
//Equation Section
equation
  Re=L*rho*v/meu;//As Re >4000 The flow is turbulent.
end Ex12_2;
//============================================================================


