// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,          USA, 2009.
// Edition : 1
// Chapter : 12 Flow mechanisms 
// Illustrative Example 12.3 Page Number 126
// Title - Reynolds number of the gas flowing
//========================================================================
model Ex12_3
//////Parameter section///////////////////////
//============================================
    parameter Real D(unit="m")=0.45             "Diameter of the duct";
    parameter Real rho(unit="kg/m^3")=1.2       "Density of the fluid";
    parameter Real v(unit="m/s")=3.8            "Velocity of the fluid";
    parameter Real meu(unit="kg/m.s")=1.73E-5   "Viscosity of thee fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real Re                                     "Reynolds number";
//============================================== 
//Equation Section
equation
  Re=D*rho*v/meu;//As Re > 4000 The flow is turbulent
end Ex12_3;
//============================================================================


