// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 12 Flow mechanisms 
// Illustrative Example 12.5 Page Number 128
// Title - Average velocity of the fluid
//========================================================================
model Ex12_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi  "The value of pi";
    parameter Real SG=0.96                        "Specific gravity";
    parameter Real R(unit="m")=0.03               "Radius of the Long ciruclar tube";
    parameter Real rhow(unit="kg/m^3")=1000       "Density of water";
//============================================= 
///////Variable section/////////////////////////// 
    Real m(unit="kg/s")                           "Mass flow rate";
    Real q(unit="m^3/s")                          "Volumetric flow rate";
    Real S(unit="m^2")                            "Cross sectional area";
    Real vav(unit="m/s")                          "Average Velocity";
//============================================== 
//Equation Section
equation
  q=2*pi*((3*R^2)-((200/3)*R^3));
  m= rhow*SG*q;
  S= pi*R^2;
  vav=q/S;
end Ex12_5;
//============================================================================



