// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes 
// Illustrative Example 13.2 Page Number 137
// Title - Pressure drop per unit length
//========================================================================
model Ex13_2
//////Parameter section///////////////////////
//============================================
  parameter Real meu(unit="lb/ft.s")=6.72E-4   "Viscosity of the fluid";
  parameter Real v(unit="ft/s")=0.13           "Velocity of the fluid";
  parameter Real D(unit="in")=2.067            "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////
  Real DelP_L(unit="psf/ft")                   "Pressure Drop per unit length"; 
//============================================== 
//Equation Section
equation
  DelP_L=32*meu*v/((D/12)^2);//As per Hagen Poiseuille equation
end Ex13_2;
//Remark:  The  answer provided in the textbook for DelP_L is wrong.Calculation error.
//============================================================================

