// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes  
// Illustrative Example 13.5 Page Number 139
// Title -  Length of the pipe to have a fully developed flow
//========================================================================
model Ex13_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi "The value of pi";
    parameter Real D(unit="ft")=0.1667           "Diameter of the tube";
    parameter Real q(unit="ft^3/s")=0.486        "Volumetric flow rate";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174"Conversion constant";
    parameter Real DelP_L(unit="psf/ft")=144     "Pressure gradient" ;
    parameter Real rho(unit="lb/ft^3")=70        "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////
    Real Re                                     "Reynolds number";
    Real meu(unit="lb/ft.s")                    "Viscosity of the fluid";
    Real S(unit="ft^2")                         "Cross sectional area";
    Real v(unit="ft/s")                         "Velocity of the fluid";
    Real f                                      "Fanning Friction factor";
    Real Le(unit="ft")                          "Entrance Length";
//============================================== 
//Equation Section
equation
    S=pi*(D^2)/4;
    v=q/S;
    meu=pi*DelP_L*(D^4)*gc/(128*q);//Assuming Laminar flow
    Re=D*v*rho/meu;//As Re<2100 The assumption holds good.
    f=16/Re;
    Le=0.05*D*Re;//If L > Le then the flow is assumed to be fully developed.
end Ex13_5;
//============================================================================
