// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.10 Page Number 163
// Title - Intensity of turbulence
//========================================================================
model Ex14_10
//////Parameter section///////////////////////
//============================================
    parameter Real vz[10]={43.4,42.1,42,40.8,38.5,37,37.5,38,39,41.7}"Velocity vz at Point P";
    parameter Real n=10"Number of time increment";
//============================================= 
///////Variable section///////////////////////////    
    Real vz_bar2 "Variance";
    Real vz_bar  "Mean velocity" ;
    Real sum[11] "Summation of vz";
    Real sum2[11]"Summation of (vz-vz_bar)^2";
    Real I       "Intensity of turbulence";
//============================================== 
//Equation Section
equation
    sum[1]=0;//Intial value is zero
    sum2[1]=0;//Intial value is zero
    for i in 1:10 loop
    sum[i+1]=sum[i]+vz[i];
    end for;
    vz_bar=sum[11]/n;
    for i in 1:10 loop
    sum2[i+1]=sum2[i]+((vz[i]-vz_bar)^2);
    end for;
    vz_bar2=sum2[11]/10;
    I=vz_bar2^0.5/vz_bar;//As per equation 14.23
end Ex14_10;
//============================================================================

