// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.3 Page Number 152
// Title - Friction factor 
//========================================================================
model Ex14_3
//////Parameter section///////////////////////
//============================================
    parameter Real Re=14080                   "Reynolds number";
    parameter Real k_D=0.004                  "k/D ratio";
    parameter Real fe=0.0085                  "Friction factor from fig 14.2";
//============================================= 
///////Variable section///////////////////////////
    Real fav   "Average value of Friction factor";
    Real fa    "Friction factor from the equation given";
    Real fb1   "Friction factor from the equation 14.8 ";
    Real fb2   "Friction factor from the equation 14.9";
    Real fc    "Friction factor from the equation 14.11";
    Real fd    "Friction factor from the equation 14.13";
//==============================================
//Equation Section
equation
    fa=0.0015+(1/(8*Re^0.3));
    fb1=0.0786/(Re^0.25);
    fb2=0.046/(Re^0.20);
    fc=1/(4*(1.14-(2*log10(k_D)))^2);
    fd=1/(2.28-(4*(log10(k_D+(21.25/(Re^0.9))))))^2;
    fav=(fa+fb1+fb2+fc+fd+fe)/6;
end Ex14_3;
//============================================================================
