// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.7 Page Number 160
// Title -  Maximum velocity 
//========================================================================
model Ex14_7
//////Parameter section///////////////////////
//============================================    
    final constant Real pi=Modelica.Constants.pi  "The value of pi";
    parameter Real SG=0.82                        "Specific gravity";
    parameter Real D(unit="m")=0.0493             "Diameter of the pipe";
    parameter Real Re=60000                       "Reynolds number";
    parameter Real meu(unit="kg/m.s")=0.0016      "Viscosity of the fluid";
    parameter Real n=7                            "From One Seventh  power law";
//============================================= 
///////Variable section/////////////////////////// 
    Real rho(unit="kg/m^3")                       "Density of the fluid";   
    Real v(unit="m/s")                            "Velocity of the fluid"; 
    Real S(unit="m^2")                            "Cross sectional area";
    Real q(unit="m^3/s")                          "Volumetric flow rate";
    Real m(unit="kg/s")                           "Mass flow rate";
    Real vmax(unit="m/s")                         "Maximum velocity of  the fluid";
    Real Lc(unit="m")                             "Critical Length";
//============================================== 
//Equation Section
equation
    rho=SG*1000;//Converting SG to Density of the fluid.
    v=Re*meu/(D*rho);
    S=pi*(D^2)/4;
    q=v*S;
    m= rho*q;
    vmax=v*(n+1)*((2*n)+1)/(2*(n^2));//The maximum velocity will be at the center line.
    Lc=4.4*(Re^(1/6))*D;//As Lc < L The assumptions that were being made are valid
end Ex14_7;
//Remark: Printing mistake in the expression q=v/S in the book
//============================================================================
