// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.9 Page Number 161
// Title - Required force to hold the pipe
//========================================================================
model Ex14_9
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi  "The value of pi";
    parameter Real P(unit="Pa")=8685              "Pressure drop in the pipe";
    parameter Real D(unit="m")=0.0493             "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////
    Real F(unit="N")                              "Force required to hold the pipe";
//============================================== 
//Equation Section
equation
   F=P*pi*D^2/4;//The force to be applied is opposite to the direction of the flow of the fluid. 
end Ex14_9;
//============================================================================



