// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 15 Compressible and sonic flow 
// Illustrative Example 15.2 Page Number 169
// Title - Nitrogen gas flowing through a duct
//========================================================================
model Ex15_2
//////Parameter section///////////////////////
//============================================
    parameter Real T(unit="K")=293             "Given Temperature";
    parameter Real R(unit="L.Pa/gmol.K")=8314.4"Gas constant";
    parameter Real k=1.4                       "k value for N2";
    parameter Real M(unit="g/gmol")=28         "Molecular  weight of nitrogen";
    parameter Real v(unit="m/s")=82            "Velocity of Nitrogen";
//============================================= 
///////Variable section///////////////////////////
    Real Ma                                   "Mach Number";
    Real c(unit="m/s")                        "Speed of sound";
//============================================== 
//Equation Section
equation
    c=(k*R*T/M)^0.5;
    Ma=v/c;//As Ma<0.3 We can neglect compressibility effects.
end Ex15_2;
//============================================================================

