// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 15 Compressible and sonic flow 
// Illustrative Example 15.7 Page Number 174
// Title - Reynolds  number for the natural gas flowing
//========================================================================
model Ex15_7
//////Parameter section///////////////////////
//============================================
  parameter Real D(unit="ft")=1              "Diameter of the pipe";
  parameter Real G(unit="lb/ft^2.s")=12.7    "Mass velocity flux";
  parameter Real meu(unit="cP")=0.011        "Viscosity of the natural gas";
//============================================= 
///////Variable section///////////////////////////
  Real Re                                     "Reynolds number";
//============================================== 
//Equation Sectio
equation
  Re=D*G/(meu*6.72E-4);//Coverting cP to lb/ft.s
end Ex15_7;
//============================================================================



