// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 15 Compressible and sonic flow 
// Illustrative Example 15.8 Page Number 174
// Title - Pressure drop due to the flowing air
//========================================================================
model Ex15_8
//////Parameter section///////////////////////
//============================================    
    parameter Real P1(unit="atm")=2.7      "Pressure at the inlet";
    parameter Real T(unit="K")=288         "Tempertaure at the inlet";
    parameter Real v(unit="m/s")=30        "Velocity at  the inlet";
    parameter Real Mw(unit="g/gmol")=29    "Molecular weight of air";
    parameter Real V(unit="dm^3/gmol")=22.4"Standard  molar volume";
    parameter Real Ts(unit="K")=273        "Standard temperature";
    parameter Real Ps(unit="atm")=1        "Standard Pressure";
    parameter Real f=0.004                 "Friction factor";
    parameter Real D(unit="m")=0.085       "Diameter of the pipe";
    parameter Real L(unit="m")=6.5          "Length of the pipe" ;
//============================================= 
///////Variable section///////////////////////////
    Real rho(unit="kg/m^3")               "Density of the fluid";
    Real G(unit="kg/m^2.s")               "Mass velocity flux";
    Real P2(unit="atm")                   "Pressure at the outlet";
    Real DelP(unit="atm")                 "Pressure Drop across the pipe";
//============================================== 
//Equation Section
equation
    rho=Mw*P1*Ts/(V*T*Ps);
    G=v*rho;
    P2= P1-((2*f*(G^2)*L)/(rho*D*101325));//Converting Pa to atm
    DelP=P1-P2;
end Ex15_8;
// Remark: The answer provided in the textbook for P2 is wrong.As the  value of L is taken as 65 m instead of 6.5 m
//============================================================================


