// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.6 Page Number 214
// Title - Centrifugal pump
//========================================================================
model Ex17_6
//////Parameter section///////////////////////
//============================================
  parameter Real rho(unit="lb/ft^3")=62.40            "Density of the fluid";
  parameter Real neta=0.6                             "Efficieny";
//============================================= 
///////Variable section///////////////////////////
  Real Ws(unit="hp")                                   "Power requirement";
  Real m(unit="lb/s")                                  "Mass flow rate";
  Real bhp(unit="hp")                                  "Brake Horse power";
  Real q(unit="gpm")                                   "Volumetric flow rate";
  Real h_c(unit="ft of water")                         "Total head developed";
  Real h_p(unit="ft of water")                         "Pump head in feet of water";
//============================================== 
//Equation Section
equation
  h_c=42-(0.0047*q^2);
  h_p=12+(0.0198*q^2);
  h_c=h_p;
  m= rho*q/448.86;//Converting gpm to cfs
  Ws=(m*h_c)*0.001818;//Conversion from lbf.ft/s to hp
  bhp=Ws/neta;
end Ex17_6;
//============================================================================
