// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 18 Valves and Fittings
// Illustrative Example 18.3 Page Number 227
// Title - Pressure Drop along the pipe
//========================================================================
model Ex18_3
//////Parameter section///////////////////////
//============================================
  parameter Real rho(unit="lb/ft^3")=62.4     "Density of the fluid";
  parameter Real meu(unit="lb/ft.s")=6.72E-4  "Viscosity of the fluid";
  parameter Real D(unit="in")=0.375           "Diameter of the pipe";
  parameter Real v(unit="ft/s")=10            "Velocity of the fluid";
  parameter Real L(unit="ft")=30              "Length of the pipe";
  parameter Real gc(unit="lb.ft/lbf.s^2")=32.2"Conversion constant";
//============================================= 
///////Variable section///////////////////////////
  Real DelP(unit="lbf/ft^2")"Pressure drop along the length of the pipe";
  Real f                 "Friction factor";
  Real Re                "Reynolds number";
//============================================== 
//Equation Section
equation
  Re= (D/12)*v*rho/meu;//Conversion of in to ft
  f=0.0015+(0.125/Re^0.3);
  DelP=(2*f*rho*v^2*L/((D/12)*gc));
end Ex18_3;
//============================================================================



