// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 18 Valves and Fittings
// Illustrative Example 18.7 Page Number 232
// Title - Friction Loss
//========================================================================
model Ex18_7
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi  "The value of pi";
  parameter Real D(unit="m")=0.0779             "Diameter of the pipe";
  parameter Real k(unit="m")=0.046E-3           "Roughness of the pipe";
  parameter Real q(unit="m^3/s")=0.0126         "Volumetric flow rate";
  parameter Real neu(unit="m^2/s")=1E-6         "Kinematic viscosity of the fluid";
  parameter Real f=0.00345                      "Friction factor";
  parameter Real L(unit="ft") =2000             "Length of the pipe";
///////Variable section///////////////////////////
//==============================================  
  Real hf(unit="J/kg")                          "Head Loss due to friction ";
  Real Re                                       "Reynolds number";
  Real S(unit="m^2")                            "Cross sectional area"; 
  Real k_D                                      "Relative roughness";
  Real v(unit="m/s")                            "Velcoity of the fluid";
  Real hs(unit="J/kg")                          "Shaft work";
//============================================= 
//Equation Section
equation
  k_D=k/D;
  S=pi*D^2/4;
  v=q/S;
  Re= D*v/neu;//As Re > 2100 The flow is turbulent.
  hf=4*f*(L*0.3048/D)*(v^2/2);
  hs=hf;//Applying Bernoulli's eqn between 1 and 2 where P1=P2=1 atm,z1=z2 and v1=v2
end Ex18_7;
//============================================================================
