// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.2 Page Number 250
// Title - Pitot tube
//========================================================================
model Ex19_2
////////////Parameter section/////////////
//=======================================
 parameter Real rho(unit="lb/ft^3")=0.075  "Density of the gas" ;
 parameter Real g(unit="ft/s^2")=32.2      "Acceleration due to gravity ";
 parameter Real h(unit="in")=0.2           "Height difference"; 
 parameter Real rho_m(unit="lb/ft^3")=62.4 "Density of water present in the U tube" ;
//=======================================
///////////Variable section//////////////
 Real vmax(unit="ft/s")  "Maximum velocity" ;
 Real v(unit="ft/s")     "Average velocity";
//========================================
//Equation section
equation
//The velocity reading was taken at the center
  vmax=(((2*g*(h/12))*(rho_m))/rho)^0.5;//Converting in to ft
  v=(0.815*vmax);//Since the flow is turbulent  
end Ex19_2;
//=========================================
