// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.4 Page Number 251
// Title - Volumetric flow rate
//===============================================================================
model Ex19_4
////////////////Parameter section///////////////
//====================================
 final constant Real pi=Modelica.Constants.pi       "The value of pi";
 parameter Real rho(unit="kg/m^3")=1000             "Density of the flowing fluid";
 parameter Real g(unit="m/s^2")=9.807               "Acceleration due to gravity";
 parameter Real h(unit="m")=0.07                    "Height rise of the fluid in the manometer";
 parameter Real rho_m(unit="kg/m^3")=13600          "Density of the manometer fluid";
 parameter Real meu(unit="kg/m.s")=0.001            "Viscosity of water";
 parameter Real D(unit="m")=0.0779                  "Diameter of 3 inch schedule 40 steel pipe";
//============================================= 
///////Variable section////////////////////////
   Real S(unit="m^2")  "Cross sectional area";
   Real q(unit="m^3/s")"Volumetric flow rate"; 
   Real v(unit="m/s")  "Velocity of water";
   Real Re             "Reynolds number";
//====================================
//Equation section
equation
 v=(((2*g*h)*(rho_m-rho))/rho)^0.5;//As per equation 19.8
 q=v*S;
 S=pi*(D^2)/4;
 Re=(v*D*rho)/meu;//The flow is turbulent as Re>4000
end Ex19_4;
//==================================
