// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.5 Page Number 254
// Title - Venturi meter 
//========================================================================
model Ex19_5
///////////Parameter section///////////
//====================================
 final constant Real pi=Modelica.Constants.pi       "the value of pi";
 parameter Real D2(unit="m")=0.02                   "Throat diameter";
 parameter Real rho(unit="kg/m^3")=680              "Density of the fluid";
 parameter Real g(unit="m/s^2")=9.807               "Acceleration due to gravity"; 
 parameter Real h(unit="m")=0.035                   "Height difference in the manometer";
 parameter Real rho_m(unit="kg/m^3")=13600          "Density of the manometer fluid";
 parameter Real D1(unit="m")=0.06                   "The upstream diameter";
 parameter Real P1(unit="Pa")=101325                "Upstream pressure";
//=========================================
////////////////////Variable section//////////////////////
 Real P2(unit="Pa")          "Pressure at the throat ";
 Real DelP(unit="Pa")        "Pressure difference";
 Real DelPl(unit="Pa")       "Pressure Loss"  ;
 Real v2(unit="m/s")         "velocity at the throat";
 Real q(unit="m^3/s")        "Volumetric flow rate";
 Real W_l(unit="W")          "Power Loss";
//========================================
//Equation section
equation
 v2=(((2*g*h)*(rho_m-rho))/(rho*(1-((D2/D1)^4))))^0.5;//As per equation 19.15 where Cv=1;
 q=v2*pi*(D2^2)/4;
 P2=P1-(g*h*(rho_m-rho));
 DelP=P1-P2;
 DelPl=0.1*DelP;//Pressure Loss is 10% of the pressure difference
 W_l=q*DelPl;
end Ex19_5;
//==========================================================================
