// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 2 Units And Dimensional Analysis
// Illustrative Example 2.1 Page Number 10
// Title - Unit Conversions
//========================================================================
model Ex2_1
//////Parameter section///////////////////////
//============================================
    parameter Real yr(unit="yr")=8.03               "Given year to be convereted to seconds";
    parameter Real mileperhour(unit="mile/h")=150   "Given mile/h to be convereted to yard/h"; 
    parameter Real gpercm3(unit="g/cm^3")=0.03      "Given g/cm^3 to be convereted to lb/ft^3";
    parameter Real meters_s2(unit="m/s^2")=100      "Given m/s^2 to be convereted to ft/min^2";
//============================================= 
///////Variable section///////////////////////////
    Real s(unit="s")                  "years is converted to  seconds";
    Real yardperhour(unit="yd/h")     "mile/h is converted to yd/h";
    Real ftpermin2(unit="ft/min^2")   "m/s^2 is converted to ft/min^2";   
    Real lbperft3(unit="lb/ft^3")     "g/cm^3 is converted to lb/ft^3";
//============================================== 
//Equation Section
equation
    s=yr*365*24*60*60;//As 1 yr= 365 day, 1 day= 24 h, 1 h =60 min, 1 min = 60 s.
    yardperhour=mileperhour*5280/3;//As  1 mile= 5280 ft , 1 yd = 3 ft
    ftpermin2=100*meters_s2*(60^2)/30.48;//As 1 ft = 30.48 cm, 1 min = 60 s , 1 m =100 cm
    lbperft3=gpercm3*(30.48^3)/454;//As 1 ft= 30.48 cm ,1 lb= 454 g
end Ex2_1;
//Remark: The answer provided in the textbook for lb/ft^3 is wrong.Calculation error.
//========================================================================
