// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.13 Page Number 289
// Title - Pitot tube
//========================================================================
model Ex21_13
//////Parameter section///////////////////////
//============================================
    final constant Real pi= Modelica.Constants.pi            "The value of pi";
    parameter Real  rho_m(unit="kg/m^3")=13600               "Density of mercury";
    parameter Real  h(unit="m")=0.04                         "height of mercury";
    parameter Real  rho(unit="kg/m^3") =919                  "Density of oil";
    parameter Real  g(unit="m/s^2")=9.804                      "Acceleration due to gravity";
    parameter Real  D(unit="m")=0.055                        "Diameter of the pipe";
    parameter Real  meu(unit="kg/m.s")=0.04                  "Viscosity of the oil";
//============================================= 
///////Variable section///////////////////////////
    Real v(unit="m/s")                                       "Velocity";
    Real S(unit="m^2")                                       "Cross sectional area";
    Real Re                                                  "Reynolds number";
    Real m(unit="kg/s")                                      "Mass flow rate";
//============================================== 
//Equation Section
equation
    v=(2*g*h*((rho_m/rho)-1))^0.5;
    S=pi*D^2/4;
    Re=(D*v*rho)/meu;//As Re > 2100 The flow is turbulent.
    m=rho*v*S;
end Ex21_13;
//Remark: The  answer provided in the textbook for Re is wrong.Calculation error.
//============================================================================
