// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.14 Page Number 290 
// Title - Estimating the velocity
//========================================================================
model Ex21_14
//////Parameter section///////////////////////
//============================================
    parameter Real  S1(unit="ft^2")=0.00133               "Cross sectional area of 3/8 inch pipe";
    parameter Real  S2(unit="ft^2")= 0.00211              "Cross sectional area of 1/2 inch pipe";
    parameter Real L(unit="ft")=50                        "Length of the pipe";
    parameter Real D(unit="ft")=0.03125                   "Diameter of the pipe";
    parameter Real v[6](each unit="ft/s")={10,8,6,4,2,0.5}"Velocity";
    parameter Real f[6]={0.007279,0.007714,0.008323,0.009282,0.01124,0.016734}"Friction factor";
//The friction factor provided in the table 21.3 is determined using Re    
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.2"unit conversion factor";
//============================================= 
///////Variable section/////////////////////////// 
    Real Ke                                                        "Expansion coefficient"; 
    Real hf[6](each unit="ft.lbf/lb")                              "Frictional Loss";
    Real Kc                                                        "Contraction coefficient";
//============================================== 
//Equation Section
equation
  Ke=(1-(S1/S2))^2;
  Kc=0.4*(1-(S2/S1));
  for i in 1:6 loop
  hf[i]=((4*f[i]*L/D)+(Ke+Kc))*(v[i]^2/(2*gc));
  end for;
//By performing linear interpolation the piping system velocity is to be 1.93 ft/s 
end Ex21_14;
//Remark:The  answer provided in the textbook for Ke and Kc is wrong.Calculation error.The viscosity of the fluid is not mentioned in the sum.Hence insufficiency in the data to calculate Re.
//============================================================================



