// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.16 Page Number 291
// Title - Pressure drop of the prototype
//========================================================================
model Ex21_16
//////Parameter section///////////////////////
//============================================
    parameter Real vp(unit="m/s")=0.02              "Velocity of water";
    parameter Real Dp(unit="m")=1.5                 "Diameter of the pipe";
    parameter Real Lp(unit="m")=20                  "Length of the pipe";
    parameter Real rhop(unit="kg/m^3")=1000         "Density of water";
    parameter Real meup(unit="kg/m.s")=0.001        "Viscosity of water";
    parameter Real kp(unit="m")=0.003               "Roughness factor";
    parameter Real rhom(unit="kg/m^3")=961.3        "Density of oil";
    parameter Real meum(unit="kg/m.s")=0.0721       "Viscosity of oil";
    parameter Real DelPm(unit="Pa")=1E5             "Pressure drop in the model";
//============================================= 
///////Variable section///////////////////////////
    Real km(unit="m")                     "Rougness factor for the modeled pipe";
    Real vm(unit="m/s")                   "Flow velocity in the modeled pipe";
    Real Lm(unit="m")                     "Length of the modeled pipe";
    Real Dm(unit="m")                     "Diameter of the modeled pipe";
    Real DelPp(unit="Pa")                 "Pressure drop of the prototype";
//============================================== 
//Equation Section
equation
    Dm=Dp/30;
    Lm=Lp*(Dm/Dp);
    km=kp*(Dm/Dp);
    vm=(rhop*vp*Dp*meum)/(rhom*Dm*meup);
    DelPm/(0.5*rhom*(vm^2))=DelPp/(0.5*rhop*(vp^2));
end Ex21_16;
//============================================================================
