// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic applications
// Illustrative Example 21.7 Page Number 284
// Title - Velocity of the fluid
//========================================================================
model Ex21_7
//////Parameter section///////////////////////
//============================================
    parameter Real D(unit="ft")=0.0411                       "Diameter of the pipe";
    parameter Real S(unit="ft^2")=0.00133                    "Cross section area of pipe";
    parameter Real meu(unit="lb/ft.s")=6.598E-4              "Viscosity of water";
    parameter Real rho(unit="lb/ft^3")=62.4                  "Density of the fluid";
    parameter Real qgpm(unit="gpm")=2                        "Volumetric flow rate";
//============================================= 
///////Variable section///////////////////////////
    Real q(unit="ft^3/s")                                    "Volumetric flow rate";
    Real v(unit="ft/s")                                      "Velocity of the fluid";
    Real Re                                                  "Reynolds number";
//============================================== 
//Equation Section     
equation
    q=qgpm*0.00228;
    v=q/S;
    Re=D*v*rho/meu;//As Re >2100 The flow is turbulent.
end Ex21_7;
//============================================================================
