// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.9 Page Number 286
// Title - Friction Loss
//========================================================================
model Ex21_9
//////Parameter section///////////////////////
//============================================
    parameter Real  DelP(unit="lbf/ft^2")=4.5              "Preesure Drop of the fluid";
    parameter Real  rho(unit="lb/ft^3")=62.4               "Density of the fluid";
    parameter Real  z2(unit="ft")=15                       "Height of the pipe";
    parameter Real  z1(unit="ft")=0                        "Bottom level";
    parameter Real g(unit="ft/s^2")=32.2                   "Acceleration due to gravity";
    parameter Real gc(unit="ft.lb/lbf.s^2")=32.2           "Conversion constant";
//============================================= 
///////Variable section///////////////////////////
    Real hf(unit="ft.lbf/lb")                              "Friction loss";
//============================================== 
//Equation Section
equation
  hf=(-DelP/rho)+((z2-z1)*(g/gc));
end Ex21_9;
//============================================================================
