// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.14 Page Number 315
// Title -  Percentage increase in the roughness.
//========================================================================
model Ex22_14
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi             "The value of pi";
    parameter Real D(unit="m")=0.2                           "Diameter of the pipe";
    parameter Real q(unit="m^3/s")=0.3                       "Volumetric flow rate";
    parameter Real meu(unit="kg/m.s")=2.92E-4                "Viscosity of the fluid";
    parameter Real rho(unit="kg/m^3")=680                    "Density of the fluid";
    parameter Real k(unit="m")=0.00026                       "Roughness factor from table 14.1";
    parameter Real f=0.00525                                 "Fanning friction factor from table 14.2";
    parameter Real L(unit="m")=30                            "Length of the pipe";
    parameter Real g(unit="m/s^2")=9.807                     "Acceleration due to gravity";
    parameter Real neta=0.8                                  "Efficieny";
    parameter Real f_smooth=0.009                            "Friction factor smooth";
    parameter Real f_rough=0.021                             "Friction factor rough";
//============================================= 
///////Variable section/////////////////////////// 
    Real piperoughness                                          "Percentage increase in the roughness";
    Real DelP(unit="Pa")                                        "Pressure Drop";
    Real hf(unit="m")                                           "Head Loss";
    Real k_D                                                    "Relative roughness";
    Real v(unit="m/s")                                          "Velcoity";
    Real S(unit="m^2")                                          "Cross sectional area";
    Real Re                                                     "Reynold number";
    Real W_id(unit="W")                                         "Ideal work";
    Real W(unit="W")                                            "Actual shaft work";
//============================================== 
//Equation Section 
equation
    v=q/S;
    S=pi*(D^2)/4;
    Re=(D*v*rho)/meu;//As Re > 4000 The flow is turbulent
    k_D=k/D;
    hf=(4*f*L*(v^2))/(2*D*g);
    DelP=(rho*g*hf);
    W_id=q*DelP;
    W=W_id/neta;
    piperoughness=100*((f_rough/f_smooth)-1);
end Ex22_14;
//Remark: The answer differs due to the approximation of v.
//========================================================================
