// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.15 Page Number 316
// Title -  Friction power loss
//========================================================================
model Ex22_15
    final constant Real pi=Modelica.Constants.pi             "The value of pi";
    parameter Real D(unit="m")=2.3                           "Diameter of the pipe";
    parameter Real q(unit="gal/min")=4000                    "Volumetric flow rate";
    parameter Real meu(unit="kg/m.s")=0.0008                 "Viscosity of the fluid";
    parameter Real f=0.0032                                  "Fanning friction factor";
    parameter Real L(unit="ft")=480                          "Length of the pipe";
    parameter Real rho(unit="kg/m^3")=899                    "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real S(unit="m^2")                                       "Cross sectional area";
    Real Re                                                  "Reynolds number";
    Real DelP(unit="Pa")                                     "Pressure Drop";
    Real Wf(unit="W")                                        "Friction power loss";
    Real v(unit="m/s")                                       "Velcoity of the fluid";
//============================================== 
//Equation Section
equation
    S=(pi*(D^2))/4;
    v=q/(S*264.17*60);//Conversion from gal/min to m^3/s
    Re=(D*v*rho)/meu;//As Re >4000 The flow is turbulent.
    DelP=(4*f*L*0.3048*(v^2)*rho)/(2*D);//Conversion of ft to m
    Wf=(q*DelP)/(264.17*60);
end Ex22_15;
//========================================================================
