// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.8 Page Number 303
// Title -  Gradual Contraction
//========================================================================
model Ex22_8
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi"The value of pi";
    parameter Real D1(unit="m")=0.1        "Upstream Diameter";
    parameter Real D2(unit="m")=0.06       "Downstream diameter";
    parameter Real g(unit="m/s^2")=9.8     "Acceleration due to gravity";
    parameter Real h(unit="m")=0.08        "Manometer head";
    parameter Real rho_m(unit="kg/m^3")=827"Density of the manometric fluid";
    parameter Real rho(unit="kg/m^3")=1.22 "Density of air";
    parameter Real T(unit="K")=293         "Temperature";
    parameter Real P1(unit="Pa")=130000    "Absolute Pressure at point 1";
//============================================= 
///////Variable section///////////////////////////     
    Real S2(unit="m^2") "Cross sectional area";
    Real q(unit="m^3/s")"Volumetric flow rate";
    Real v2(unit="m/s") "Velocity at point 2";
    Real c(unit="m/s") "Speed of light at this temperature";
    Real Ma            "Mach number";
    Real P2(unit="Pa") "Pressure at point 2";
    Real v1(unit="m/s")"Velocity at point 1";
//============================================== 
//Equation Section      
equation
    S2=pi*(D2^2)/4;
    q=v2*S2;
    v1=v2*((D2/D1)^2);
    v2=((2*g*h*((rho_m/rho)-1))^0.5);
    c=(20*(T^0.5));
    Ma=v2/c;//As Ma<0.3 The flow is incompressibe
    P1-P2=(rho*(v2^2)*(1-((D2/D1)^4)))/2;//Using Bernoullis equation.
end Ex22_8;
//=============================================================================
