// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.9 Page Number 305
// Title -  Friction Loss
//========================================================================
model Ex22_9
//////Parameter section///////////////////////
//============================================
    parameter Real P1(unit="psia")=30                "Pressure at point 1";
    parameter Real P2(unit="psia")=18                "Pressure at point 2";
    parameter Real Z2(unit="ft")=-10                 "Height below the turbine";
    parameter Real Z1(unit="ft")=300                 "Height at point 1";
    parameter Real Ws(unit="hp")=1000                "Shaft work";
    parameter Real rho(unit="lb/ft^3")=62.4          "Density of the fluid";
    parameter Real neta=0.9                          "Efficiency of the turbine";
    parameter Real m(unit="tons/hr")=3600            "Mass flow rate";
//============================================= 
///////Variable section///////////////////////////
    Real hf(unit="ft.lbf/lb")                        "Friction Loss";
    Real hs(unit="ft.lbf/lb")                        "Work done";
//============================================== 
//Equation Section    
equation
hs=(Ws*550*3600)/(neta*m*2000);//Converting the units to ft.lbf/lb
(((P2-P1)*144)/rho)+(Z2-Z1)-hs+hf=0;//As per Bernoullis modified equation
end Ex22_9;
// Remark: Printing mistake in the value of hf in the textbook.
//=============================================================================
