// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.4 Page Number 336
// Title -  Velocity of the particle
//============================================================================
model Ex23_4
//========================================================================
//////Parameter section///////////////////////    
    parameter Real sg=2.31                          "Specific gravity";
    parameter Real rho_w(unit="lb/ft^3")=62.4       "Density of water";
    parameter Real R(unit="atm.ft^3/lbmol.degR")=0.7302"Gas constant";
    parameter Real T(unit="degR")=698                 "Given temperature";
    parameter Real P(unit="atm")=1                 "Given pressure";
    parameter Real M(unit="lb/lbmol")=29           "Molecular weight";
    parameter Real meu(unit="lb/ft.s")=1.41E-5     "Viscosity of the fluid";
    parameter Real g(unit="ft/s^2")=32.174         "Acceleration due to gravity";
    parameter Real dp1(unit="microns")=0.4         "Diameter of the particle 1";                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
    parameter Real dp2(unit="microns")=40          "Diameter of the particle 2";
    parameter Real dp3(unit="microns")=400         "Diametr of the particle 3" ;
    parameter Real t(unit="s")=30                  "Time";
    parameter Real lamda(unit="m")=6.53E-8         "Mean free path";
    parameter Real g_acc(unit="ft/s^2")=32.2       "Aproximated value of g";
///////Variable section///////////////////////////
//==============================================
    Real A                                         "Experimental coefficient";
    Real C                                         "Cunnigham correction factor";
    Real x2(unit="ft")                             "Distance travel by 2 particle";
    Real x3(unit="ft")                             "Distance travel by 3 particle";
    Real K1                                        "Criterion for settling for particle 1";
    Real K2                                        "Criterion for settling for particle 2";
    Real K3                                        "Criterion for settling for particle 3";
    Real rho_a(unit="lb/ft^3")                     "Density of air";
    Real rho_p(unit="lb/ft^3")                     "Density of the particle";
    Real v1(unit="ft/s")                           "Velocity of particle 1";
    Real v2(unit="ft/s")                           "Velocity of particle 2";
    Real v3(unit="ft/s")                           "Velocity of particle 3";
    Real v1_c(unit="ft/s")                         "Corrected velocity of particle 1";
    Real x1(unit="ft")                             "Distance travelled by  particle 1";
//============================================= 
//Equation Section    
equation
    rho_p=sg*rho_w;
    rho_a=(P*M)/(R*T);
//Determining K value for each particle that is settling
//Converting dp from microns to ft
    K1=(dp1/(25400*12))*((g*rho_p*rho_a/(meu^2))^(1/3));//Stokes Law applies as K<3.3
    K2=(dp2/(25400*12))*((g*rho_p*rho_a/(meu^2))^(1/3));//Stokes Law applies as K<3.3
    K3=(dp3/(25400*12))*((g*rho_p*rho_a/(meu^2))^(1/3));// The intermediate regime applies As 43.6>K >3.3.
//Based on K determinig the terminal settling velocity 
    v1=((dp1/(25400*12))^2)*g_acc*rho_p/(18*meu);
    v2=((dp2/(25400*12))^2)*g_acc*rho_p/(18*meu);
    v3=(0.153*(dp3/(25400*12))^1.14)*(g_acc^0.71)*(rho_p^0.71)/((rho_a^0.29)*(meu^0.43));
    x2=v2*t;
    x3=v3*t;
    A=1.257+(0.4*exp(-1.10*dp1/(2*lamda*(10^6))));
    C=1+(2*A*lamda*(10^6)/dp1);
    v1_c=v1*C;
    x1=v1_c*t;
end Ex23_4;
//============================================================================
