// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.2 Page Number 352
// Title -  Reynolds number
//========================================================================
model Ex24_2
//////Parameter section///////////////////////
//============================================
    parameter Real rhom(unit="kg/m^3")=1553           "Density of the substance";
    parameter Real v(unit="m/s")=0.00153              "Velocity ";
    parameter Real dp(unit="m")=1.554E-4              "Diameter of the particle";
    parameter Real meu(unit="kg/m.s")=0.0049          "Viscosity of the fluid";
    parameter Real ef=0.622                           "Volume fraction of the fluid particle";
//============================================= 
///////Variable section///////////////////////////
    Real Re"Reynolds number";
//============================================== 
//Equation Section
equation
    Re=(rhom*v*dp)/(meu*ef);
end Ex24_2;
//============================================================================
